#pragma dynamic 131072 //I used to much memory =(
/*
 *	CVARs:
 *		- These CVARS can be changed at any time during round!
 *		sj_kick 		(default: 650)	- Default Kicking Speed.
 *		sj_score 		(default: 15)	- Scores needed to win a round.
 *		sj_reset 		(default: 30.0)	- Ball reset time, to respawn at ball spawn location.
 *		sj_goalsafety 	(default: 650)	- Distance around Mascot, that does damage to enemy.
 *		sj_random		(default: 1)	- Turns Team Randomizing ON/OFF.
 *
 *	Requires:	AMXX 1.75+
 *
 *	Author:		OneEyed
 *	IRC:		#soccerjam (irc.gamesurge.net)
 *	Website:	http://www.soccer-jam.com/
 */

/* ------------------------------------------------------------------------- */
/* /----------------------- START OF CUSTOMIZATION  -----------------------/ */
/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */
/* /------------  CUSTOM DEFINES  ------------ CUSTOM DEFINES  ------------/ */
/* ------------------------------------------------------------------------- */

// Disable knife disarm ? (Leaves only ball disarm)
// Comment this define to disable.
#define KNIFE_DISARM_ON

//When player reaches MAX level, they receive this many levels.
#define MAX_LVL_BONUS 1

//Max levels for each upgrade
#define MAX_LVL_STAMINA		5
#define MAX_LVL_STRENGTH	5
#define MAX_LVL_AGILITY		5
#define MAX_LVL_DEXTERITY	5
#define MAX_LVL_DISARM		5
#define MAX_LVL_POWERPLAY	5

//Prices for each upgrade.
//price = ((UpgradeLevel * UpgradePrice) / 2) + UpgradePrice
#define EXP_PRICE_STAMINA	220
#define EXP_PRICE_STRENGTH	200
#define EXP_PRICE_AGILITY	300
#define EXP_PRICE_DEXTERITY	200
#define EXP_PRICE_DISARM	200

//Experience per stat.
#define EXP_GOALY	100 //for goaly save and goaly points.
#define EXP_STEAL 	100
#define EXP_KILL 	100
#define EXP_ASSIST	200
#define EXP_GOAL	100

#define BASE_HP 100		  	//starting hp
#define BASE_SPEED 	250.0 	//starting run speed
#define BASE_DISARM	10 		//starting disarm from lvl 1

#define COUNTDOWN_TIME 10	//Countdown time between rounds.
#define GOALY_DELAY 8.0		//Delay for goaly exp

//Curve Ball Defines
#define CURVE_ANGLE		15	//Angle for spin kick multipled by current direction.
#define CURVE_COUNT		6	//Curve this many times.
#define CURVE_TIME		0.2	//Time to curve again.
#define DIRECTIONS		2	//# of angles allowed.
#define	ANGLEDIVIDE		6	//Divide angle this many times for curve.

//Misc. amounts
#define AMOUNT_LATEJOINEXP	100	//latejoinexp * each scored point.
#define AMOUNT_POWERPLAY 	5	//added bonus to STR and AGI per powerplay lvl.
#define AMOUNT_GOALY 		7	//Goaly camper exp

//Amount of points for each upgrade.
#define AMOUNT_STA 		20	//Health per lvl
#define AMOUNT_STR 		30	//Stronger kicking per lvl
#define AMOUNT_AGI 		13	//Faster Speed per lvl
#define AMOUNT_DEX 		10	//Better Catching
#define AMOUNT_DISARM 	2	//Disarm ball chance (disarm lvl * this) if random num 1-100 < disarm

#define DISARM_MULTIPLIER 3
/* ------------------------------------------------------------------------- */
/* /----------------  TEAM NAMES  ------------ TEAM NAMES  ------------/ */
/* ------------------------------------------------------------------------- */

#define TEAMS 4 //Don't edit this.

//Names to be put on scoreboard.
static const TeamNames[TEAMS][] = {
	"NULL",
	"Terr",	//Terrorist Team
	"CT",	//CT Team
	"NULL"
}
/* ------------------------------------------------------------------------- */
/* /----------------  MODELS  ---------------- MODELS  ----------------/ */
/* ------------------------------------------------------------------------- */
//You may change the ball model. Just give correct path of new model.
new ball[] = "models/kickball/ball.mdl"

static const TeamMascots[2][] = {
	"models/kingpin.mdl",	//TERRORIST MASCOT
	"models/garg.mdl"		//CT MASCOT
}
/* ------------------------------------------------------------------------- */
/* /----------------  COLORS  ---------------- COLORS  ----------------/ */
/* ------------------------------------------------------------------------- */
//Format is RGB 0-255

//TEAM MODEL GLOW COLORS
#define TERR_GLOW_RED	250
#define TERR_GLOW_GREEN	10
#define	TERR_GLOW_BLUE	10

#define CT_GLOW_RED		10
#define	CT_GLOW_GREEN	10
#define CT_GLOW_BLUE	250

//TEAM HUD METER COLOR (Turbo/Curve Angle meters)
#define TERR_METER_RED		250
#define TERR_METER_GREEN	10
#define	TERR_METER_BLUE		10

#define CT_METER_RED	10
#define	CT_METER_GREEN	10
#define CT_METER_BLUE	250

//BALL GLOW COLOR (default: yellow) //it glows only one color
#define BALL_RED	255
#define BALL_GREEN	200
#define BALL_BLUE	100

//BALL BEAM
#define BALL_BEAM_WIDTH		5
#define BALL_BEAM_LIFE		10
#define BALL_BEAM_RED		250
#define BALL_BEAM_GREEN		80
#define BALL_BEAM_BLUE		10
#define BALL_BEAM_ALPHA		175

/* ------------------------------------------------------------------------- */
/* /----------------  SOUNDS  ---------------- SOUNDS  ----------------/ */
/* ------------------------------------------------------------------------- */
//-- NOTE: Sounds must be located in sound/kickball/ folder.

new BALL_BOUNCE_GROUND[] = "kickball/bounce.wav"
new BALL_RESPAWN[] = "kickball/returned.wav"
new BALL_KICKED[] = "kickball/kicked.wav"
new BALL_PICKED_UP[] = "kickball/gotball.wav"
new UPGRADED_MAX_LEVEL[] = "kickball/levelup.wav"
new ROUND_START[] = "kickball/prepare.wav"
new SCORED_GOAL[] = "kickball/distress.wav"
new STOLE_BALL_FAST[] = "kickball/pussy.wav"

//When a goal is scored, one of these will randomly play.
#define MAX_SOUNDS 6
new SCORED_SOUNDS[MAX_SOUNDS][] = {
	"kickball/amaze.wav",
	"kickball/laugh.wav",
	"kickball/perfect.wav",
	"kickball/diebitch.wav",
	"kickball/bday.wav",
	"kickball/boomchakalaka.wav"
}
/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */
/* /------------------------ END OF CUSTOMIZATION  ------------------------/ */
/* ------------------------------------------------------------------------- */
/* ------------------------------------------------------------------------- */

/* ------------ DO NOT EDIT BELOW ---------------------------------------------------------- */
/* -------------------------- DO NOT EDIT BELOW -------------------------------------------- */
/* --------------------------------------- DO NOT EDIT BELOW ------------------------------- */
/* ---------------------------------------------------- DO NOT EDIT BELOW ------------------ */

#include <amxmodx>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <fun>

static const AUTHOR[] = "OneEyed"
static const VERSION[] = "2.07a"

#define MAX_TEXT_BUFFER		2047
#define MAX_NAME_LENGTH		33
#define MAX_PLAYER			33
#define MAX_ASSISTERS		3
#define MAX_BALL_SPAWNS		5
#define POS_X 		-1.0
#define POS_Y 		0.85
#define HUD_CHANNEL 4
#define MESSAGE_DELAY 4.0

enum {
	UNASSIGNED = 0,
	T,
	CT,
	SPECTATOR
}

#define RECORDS 6
enum {
	GOAL = 1,
	ASSIST,
	STEAL,
	KILL,
	DISTANCE,
	GOALY
}

#define UPGRADES 5
enum {
	STA = 1,	//stamina
	STR,		//strength
	AGI,		//agility
	DEX,		//dexterity
	DISARM,
}

static const UpgradeTitles[UPGRADES+1][] = {
	"NULL",
	"Stamina",
	"Strength",
	"Agility",
	"Dexterity",
	"Disarm"
}

new const UpgradeMax[UPGRADES+1] = {
	0, //NULL
	MAX_LVL_STAMINA, 	//STAMINA
	MAX_LVL_STRENGTH, 	//STRENGTH
	MAX_LVL_AGILITY, 	//AGILITY
	MAX_LVL_DEXTERITY, 	//DEXTERITY
	MAX_LVL_DISARM, 	//DISARM
}

new const UpgradePrice[UPGRADES+1] = {
	0, //NULL
	EXP_PRICE_STAMINA,
	EXP_PRICE_STRENGTH,
	EXP_PRICE_AGILITY,
	EXP_PRICE_DEXTERITY,
	EXP_PRICE_DISARM,
}

new TeamColors[TEAMS][3] =
{
	{ 0, 0, 0 },
	{ TERR_GLOW_RED, TERR_GLOW_GREEN, TERR_GLOW_BLUE } ,
	{ CT_GLOW_RED, CT_GLOW_GREEN, CT_GLOW_BLUE },
	{ 0, 0, 0 }
}

new TeamMeterColors[TEAMS][3] =
{
	{ 0, 0, 0 },
	{ TERR_METER_RED, TERR_METER_GREEN, TERR_METER_BLUE } ,
	{ CT_METER_RED, CT_METER_GREEN, CT_METER_BLUE },
	{ 0, 0, 0 }
}


new ballcolor[3] = { BALL_RED, BALL_GREEN, BALL_BLUE }
new PlayerUpgrades[MAX_PLAYER][UPGRADES+1]
new GoalEnt[TEAMS]
new PressedAction[MAX_PLAYER]
new seconds[MAX_PLAYER]
new g_sprint[MAX_PLAYER]
new SideJump[MAX_PLAYER]
new Float:SideJumpDelay[MAX_PLAYER]
new PlayerDeaths[MAX_PLAYER]
new PlayerKills[MAX_PLAYER]
new curvecount
new direction
new maxplayers
new Float:BallSpinDirection[3]
new ballspawncount
new Float:TeamBallOrigins[TEAMS][3]
new Float:TEMP_TeamBallOrigins[3]
new Mascots[TEAMS]
new Float:MascotsOrigins[3]
new Float:MascotsAngles[3]
new menu_upgrade[MAX_PLAYER]
new Float:fire_delay
new winner
new Float:GoalyCheckDelay[MAX_PLAYER]
new GoalyCheck[MAX_PLAYER]
new GoalyPoints[MAX_PLAYER]
new Float:BallSpawnOrigin[MAX_BALL_SPAWNS][3]
new TopPlayer[2][RECORDS+1]
new MadeRecord[MAX_PLAYER][RECORDS+1]
new TopPlayerName[RECORDS+1][MAX_NAME_LENGTH]
new g_Experience[MAX_PLAYER]
new timer
new Float:testorigin[3]
new Float:velocity[3]
new score[TEAMS]
new scoreboard[1025]
new temp1[64], temp2[64]
new distorig[2][3] //distance recorder
new gmsgShake
new gmsgDeathMsg
new gmsgSayText
new gmsgTextMsg
new goaldied[MAX_PLAYER]
new bool:is_dead[MAX_PLAYER]
new terr[33], ct[33], cntCT, cntT
new PowerPlay, powerplay_list[MAX_LVL_POWERPLAY+1]
new assist[16]
new iassist[TEAMS]
new gamePlayerEquip
new CVAR_SCORE
new CVAR_RESET
new CVAR_GOALSAFETY
new CVAR_KICK
new Float:CVAR_RESPAWN
new CVAR_RANDOM
new fire
new smoke
new beamspr
new g_fxBeamSprite
new Burn_Sprite
new ballholder
new ballowner
new aball
new is_kickball
new g_TimeLimit;
new bool:has_knife[MAX_PLAYER]

new OFFSET_INTERNALMODEL;

/*====================================================================================================
 [Precache]

 Purpose:	$$

 Comment:	$$

====================================================================================================*/
PrecacheSounds() {
	new x
	for(x=0;x<MAX_SOUNDS;x++)
		engfunc( EngFunc_PrecacheSound, SCORED_SOUNDS[x])

	engfunc( EngFunc_PrecacheSound, STOLE_BALL_FAST)
	engfunc( EngFunc_PrecacheSound, ROUND_START)
	engfunc( EngFunc_PrecacheSound, BALL_BOUNCE_GROUND)
	engfunc( EngFunc_PrecacheSound, BALL_PICKED_UP)
	engfunc( EngFunc_PrecacheSound, BALL_RESPAWN)
	engfunc( EngFunc_PrecacheSound, SCORED_GOAL)
	engfunc( EngFunc_PrecacheSound, BALL_KICKED)
	engfunc( EngFunc_PrecacheSound, UPGRADED_MAX_LEVEL)
}

PrecacheBall() {
	engfunc( EngFunc_PrecacheModel, ball)
}

PrecacheMonsters(team) {
	engfunc( EngFunc_PrecacheModel, TeamMascots[team-1])
}

PrecacheSprites() {
	beamspr = engfunc( EngFunc_PrecacheModel,"sprites/laserbeam.spr")
	fire = engfunc( EngFunc_PrecacheModel,"sprites/shockwave.spr")
	smoke = engfunc( EngFunc_PrecacheModel,"sprites/steam1.spr")
	Burn_Sprite = engfunc( EngFunc_PrecacheModel,"sprites/xfireball3.spr")
	g_fxBeamSprite = engfunc( EngFunc_PrecacheModel,"sprites/lgtning.spr")
}

PrecacheOther() {
	engfunc( EngFunc_PrecacheModel, "models/chick.mdl")
}

/*====================================================================================================
 [Initialize]

 Purpose:	$$

 Comment:	$$

====================================================================================================*/
public plugin_init() {

	new mapname[64]
	get_mapname(mapname,63)

	register_cvar("soccer_jam_online", "0", FCVAR_SERVER)
	register_cvar("soccer_jam_version", VERSION, FCVAR_SERVER)
	set_cvar_string("soccer_jam_version", VERSION)
	register_dictionary("soccerjam.txt")
	register_dictionary("soccerjam_help.txt")
	if(is_kickball > 0)
	{
		PrecacheSprites()

		register_plugin("Soccer Jam(ON)", VERSION, AUTHOR)
		set_cvar_num("soccer_jam_online", 1)

		timer = COUNTDOWN_TIME

		gmsgTextMsg = get_user_msgid("TextMsg")
		gmsgDeathMsg = get_user_msgid("DeathMsg")
		gmsgShake = get_user_msgid("ScreenShake")
		gmsgSayText = get_user_msgid("SayText")

		maxplayers = get_maxplayers()

		if(equali(mapname,"soccerjam")) {
			PrecacheOther()
			CreateGoalNets()
			create_wall()
		}

		register_clcmd("say","handle_say")

		register_event("ResetHUD", "Event_ResetHud", "be")
		register_event("HLTV","Event_StartRound","a","1=0","2=0")
		register_event("Damage", "Event_Damage", "b", "2!0", "3=0", "4!0" )

		CVAR_SCORE = register_cvar("sj_score","15")
		CVAR_RESET = register_cvar("sj_reset","30.0")
		CVAR_GOALSAFETY = register_cvar("sj_goalsafety","650")
		CVAR_KICK = register_cvar("sj_kick","650")
		CVAR_RESPAWN = 2.0 //register_cvar("kickball_respawn","2.0")
		CVAR_RANDOM = register_cvar("sj_random","1")
		register_cvar( "sj_timelimit", "0" );
		
		register_cvar("SCORE_CT","0")
		register_cvar("SCORE_T","0")

		register_menucmd(register_menuid("Team_Select",1), (1<<0)|(1<<1)|(1<<4)|(1<<5), "team_select")

		register_touch("PwnBall", "player", 			"touchPlayer")
		register_touch("PwnBall", "soccerjam_goalnet",	"touchNet")

		register_touch("PwnBall", "worldspawn",			"touchWorld")
		register_touch("PwnBall", "func_wall",			"touchWorld")
		register_touch("PwnBall", "func_door",			"touchWorld")
		register_touch("PwnBall", "func_door_rotating", "touchWorld")
		register_touch("PwnBall", "func_wall_toggle",	"touchWorld")
		register_touch("PwnBall", "func_breakable",		"touchWorld")
		register_touch("PwnBall", "Blocker",			"touchBlocker")

		set_task(0.4,"meter",0,_,_,"b")
		set_task(0.5,"statusDisplay",7654321,"",0,"b")

		register_think("PwnBall","ball_think")
		register_think("Mascot", "mascot_think")

		register_clcmd("radio1", "LeftDirection", 0)
		register_clcmd("radio2", "RightDirection", 0)
		register_clcmd("drop","Turbo")
  	 	register_clcmd("lastinv","BuyUpgrade")
  	 	register_clcmd("fullupdate","fullupdate")
  	 	register_message(gmsgTextMsg, "editTextMsg")

  	 	register_event("ShowMenu", "menuclass", "b", "4&CT_Select", "4&Terrorist_Select");
  	 	register_event("VGUIMenu", "menuclass", "b", "1=26", "1=27");

  	 	OFFSET_INTERNALMODEL = is_amd64_server() ? 152 : 126;
	}
	else {
		register_plugin("Soccer Jam(OFF)", VERSION, AUTHOR)
		set